const express = require("express");
const orderController = require("../controllers/orderController");
const authController = require("../controllers/authController");

const router = express.Router();

router.use(authController.protect);

// --- User Routes ---
// User buys a course
router.post("/checkout", orderController.createOrder);
// User sees their history
router.get("/my-orders", orderController.getMyOrders);

// --- Admin Routes ---
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").get(orderController.getAllOrders);

module.exports = router;
